#include "DComboBox.h"

namespace DWL {
    //
    //! Funcin para crear el control
    //  HWND Crear(const long Estilos, HWND hWndPadre, const TCHAR *Text, const int cX, const int cY, const int cAncho, const int cAltoListaCombo, const UINT cID)
    HWND DComboBox::Crear(DBaseWnd *nPadre, const TCHAR *nTexto, const int cX, const int cY, const int cAncho, const int cAltoListaCombo, const UINT cID, const DWORD Estilos) {
        if (nPadre == NULL) throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_BaseWndNULL)); 
        Destruir();
	    _hWnd = CreateWindow(TEXT("COMBOBOX"), NULL, Estilos, cX, cY, cAncho, cAltoListaCombo, nPadre->hWnd(), reinterpret_cast<HMENU>(IntToPtr(cID)), GetModuleHandle(NULL), NULL);
	    _ConectarControl(cID, nPadre);
		if (nTexto != NULL) AsignarTexto(nTexto);
        return _hWnd;
    }

	//
	//! Funcin para asignar un EditBox ya creado en un Dialogo
	//  void Asignar(HWND hWndPadre, const int ID_Control, const TCHAR *nTexto);
    HWND DComboBox::Asignar(DBaseWnd *nPadre, const UINT cID, const TCHAR *nTexto) {
        if (nPadre == NULL) throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_BaseWndNULL)); 
        Destruir();
		_hWnd = GetDlgItem(nPadre->hWnd(), cID);
		_ConectarControl(cID, nPadre);
		if (nTexto != NULL) AsignarTexto(nTexto);
        return _hWnd;
    }

    //
    //! Window procedure que reemplazara al WindowProcedure del ComboBox
    //  LRESULT CALLBACK GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam);
/*    LRESULT CALLBACK DComboBox::GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam) {
		switch (uMsg) {
			case WM_LBUTTONUP :
				PostMessage(GetParent(_hWnd), DWL_COMBOBOX_CLICK_IZQUIERDO, ID(), lParam);
				break;
			case WM_RBUTTONUP :
				PostMessage(GetParent(_hWnd), DWL_COMBOBOX_CLICK_DERECHO, ID(), lParam);
				break;
			case WM_MBUTTONUP :
				PostMessage(GetParent(_hWnd), DWL_COMBOBOX_CLICK_MEDIO, ID(), lParam);
				break;
			case WM_LBUTTONDBLCLK :
				PostMessage(GetParent(_hWnd), DWL_COMBOBOX_DOBLECLICK_IZQUIERDO, ID(), lParam);
				break;
			case WM_RBUTTONDBLCLK :
				PostMessage(GetParent(_hWnd), DWL_COMBOBOX_DOBLECLICK_DERECHO, ID(), lParam);
				break;
			case WM_MBUTTONDBLCLK :
				PostMessage(GetParent(_hWnd), DWL_COMBOBOX_DOBLECLICK_MEDIO, ID(), lParam);
				break;
			case WM_KEYDOWN :
				PostMessage(GetParent(_hWnd), DWL_COMBOBOX_TECLADO_PRESIONADO, wParam, (LPARAM)ID());
				break;
			case WM_KEYUP :
				PostMessage(GetParent(_hWnd), DWL_COMBOBOX_TECLADO_SOLTADO, wParam, (LPARAM)ID());
				if (wParam == 13) {
					PostMessage(GetParent(_hWnd), DWL_COMBOBOX_TECLADO_INTRO, wParam, (LPARAM)ID());
				}
				break;
			case WM_SETFOCUS :
				PostMessage(GetParent(_hWnd), DWL_COMBOBOX_FOCO_OBTENIDO, ID(), lParam);
				break;
			case WM_KILLFOCUS :
				PostMessage(GetParent(_hWnd), DWL_COMBOBOX_FOCO_PERDIDO, ID(), lParam);
				break;
		}
		return DBaseControlWin::GestorMensajes(uMsg, wParam, lParam); 
    };*/
};